/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.util.AbstractResponse;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;

public class ClientAuthResponse
extends AbstractResponse {
    private static final String FIELD_SUCCESS = "success";
    private static final String FIELD_ERROR_MSG = "error-msg";
    private static final String FIELD_REALNAME = "realname";
    private static final String FIELD_AUTH_COOKIE = "authCookie";
    private static final String FIELD_MOBILE_RELEASE_ENABLED = "isMobileReleaseEnabled";
    private static final String FIELD_REMEMBER_ME_ENABLED = "rememberMeEnabled";
    private String _realName;
    private String _authCookie;
    private boolean _mobileReleaseEnabled;
    private final boolean _rememberMeEnabled;

    private ClientAuthResponse(boolean success, String realName, String authCookie, String errorMessage, boolean mobileReleaseEnabled, boolean rememberMeEnabled) {
        super(success, errorMessage);
        this.setRealName(realName);
        this._authCookie = StringUtils.trimToEmpty((String)authCookie);
        this._mobileReleaseEnabled = mobileReleaseEnabled;
        this._rememberMeEnabled = rememberMeEnabled;
    }

    public static ClientAuthResponse newSuccess(String realName, String authCookie) {
        return new ClientAuthResponse(true, realName, authCookie, "", false, false);
    }

    public static ClientAuthResponse newSuccess(String realName, String authCookie, boolean mobileReleaseEnabled, boolean rememberMeEnabled) {
        return new ClientAuthResponse(true, realName, authCookie, "", mobileReleaseEnabled, rememberMeEnabled);
    }

    public static ClientAuthResponse newFail(String errorMessage) {
        return new ClientAuthResponse(false, "", "", errorMessage, false, false);
    }

    public static ClientAuthResponse newFail(String errorMessage, boolean rememberMeEnabled) {
        return new ClientAuthResponse(false, "", "", errorMessage, false, rememberMeEnabled);
    }

    public ClientAuthResponse(Hashtable<String, Object> data) {
        this(false, "", "", "", false, false);
        String strValue;
        if (data.size() == 0) {
            return;
        }
        Boolean boolValue = (Boolean)data.get(FIELD_SUCCESS);
        if (boolValue != null) {
            this.setSuccess(boolValue);
        }
        if ((strValue = (String)data.get(FIELD_ERROR_MSG)) != null) {
            this.setErrorMessage(strValue);
        }
        if ((strValue = (String)data.get(FIELD_REALNAME)) != null) {
            this.setRealName(strValue);
        }
        if ((strValue = (String)data.get(FIELD_AUTH_COOKIE)) != null) {
            this._authCookie = StringUtils.trimToEmpty((String)strValue);
        }
    }

    public Hashtable<String, Object> saveToHashtable() {
        Hashtable<String, Object> data = new Hashtable<String, Object>(2);
        data.put(FIELD_SUCCESS, this.isSuccess());
        if (!this.isSuccess() && StringUtils.isNotBlank((String)this.getErrorMessage())) {
            data.put(FIELD_ERROR_MSG, this.getErrorMessage());
        }
        data.put(FIELD_REALNAME, this.getRealName());
        if (StringUtils.isNotBlank((String)this.getAuthCookie())) {
            data.put(FIELD_AUTH_COOKIE, this.getAuthCookie());
        }
        data.put(FIELD_MOBILE_RELEASE_ENABLED, this._mobileReleaseEnabled);
        data.put(FIELD_REMEMBER_ME_ENABLED, this._rememberMeEnabled);
        return data;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(StringUtils.trimToEmpty((String)errorMessage));
    }

    public String getRealName() {
        return this._realName;
    }

    public void setRealName(String realName) {
        this._realName = StringUtils.trimToEmpty((String)realName);
    }

    public final String getAuthCookie() {
        return this._authCookie;
    }
}

