/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.PropertiesUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lbiz/papercut/pcng/util/ConfigFile;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "load", "Ljava/util/Properties;", "file", "Ljava/io/File;", "configFilePath", "", "papercut-common"})
public final class ConfigFile {
    private static final Logger logger;
    public static final ConfigFile INSTANCE;

    @JvmStatic
    @NotNull
    public static final Properties load(@NotNull String configFilePath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)configFilePath, (String)"configFilePath");
        File f = new File(configFilePath);
        logger.debug("Loading config file: {}", (Object)f.getPath());
        if (!f.exists() || !f.isFile()) {
            throw (Throwable)new FileNotFoundException("PaperCut config file '" + configFilePath + "' does not exist.");
        }
        if (!f.canRead()) {
            throw (Throwable)new FileNotFoundException("No permissions to read the config file '" + configFilePath + "'. Check the file permissions.");
        }
        return INSTANCE.load(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Properties load(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(file);
        try {
            PropertiesUtils.loadProperties(fis, props);
        }
        finally {
            fis.close();
        }
        return props;
    }

    private ConfigFile() {
    }

    static {
        ConfigFile configFile;
        INSTANCE = configFile = new ConfigFile();
        logger = LoggerFactory.getLogger(ConfigFile.class);
    }
}

