/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lbiz/papercut/pcng/util/VersionUtils;", "", "()V", "MAJOR_MINOR_BUILD_VERSION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "fromString", "Lbiz/papercut/pcng/util/VersionUtils$Version;", "versionString", "", "Version", "papercut-common"})
public final class VersionUtils {
    private static final Pattern MAJOR_MINOR_BUILD_VERSION;
    public static final VersionUtils INSTANCE;

    @JvmStatic
    @Nullable
    public static final Version fromString(@NotNull String versionString) {
        Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
        Matcher matcher = MAJOR_MINOR_BUILD_VERSION.matcher(versionString);
        if (matcher.find()) {
            Version version;
            try {
                version = new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
            catch (NumberFormatException ex) {
                version = null;
            }
            return version;
        }
        return null;
    }

    private VersionUtils() {
    }

    static {
        VersionUtils versionUtils;
        INSTANCE = versionUtils = new VersionUtils();
        MAJOR_MINOR_BUILD_VERSION = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)*");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lbiz/papercut/pcng/util/VersionUtils$Version;", "", "major", "", "minor", "build", "(III)V", "getBuild", "()I", "getMajor", "getMinor", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "papercut-common"})
    public static final class Version
    implements Comparable<Version> {
        private final int major;
        private final int minor;
        private final int build;

        @Override
        public int compareTo(@NotNull Version other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            int res = this.major - other.major;
            if (res != 0) {
                return res;
            }
            res = this.minor - other.minor;
            if (res != 0) {
                return res;
            }
            return this.build - other.build;
        }

        @NotNull
        public String toString() {
            String string = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("major", this.major).append("minor", this.minor).append("build", this.build).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ToStringBuilder(this, To\u2026              .toString()");
            return string;
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public final int getBuild() {
            return this.build;
        }

        public Version(int major, int minor, int build) {
            this.major = major;
            this.minor = minor;
            this.build = build;
        }

        public final int component1() {
            return this.major;
        }

        public final int component2() {
            return this.minor;
        }

        public final int component3() {
            return this.build;
        }

        @NotNull
        public final Version copy(int major, int minor, int build) {
            return new Version(major, minor, build);
        }

        public static /* synthetic */ Version copy$default(Version version, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = version.major;
            }
            if ((n4 & 2) != 0) {
                n2 = version.minor;
            }
            if ((n4 & 4) != 0) {
                n3 = version.build;
            }
            return version.copy(n, n2, n3);
        }

        public int hashCode() {
            return (this.major * 31 + this.minor) * 31 + this.build;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Version)) break block3;
                    Version version = (Version)object;
                    if (this.major != version.major || this.minor != version.minor || this.build != version.build) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

