/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.io;

import biz.papercut.pcng.util.io.SecureSerializationFilter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lbiz/papercut/pcng/util/io/SecureSerializationFilter;", "", "()V", "logger", "Lmu/KLogger;", "defaultPatterns", "Ljava/util/Properties;", "filterPattern", "", "serializationConfigFile", "getFilterProperties", "installGlobalFilter", "", "loadProperties", "filePath", "getMultiValueProperty", "", "propName", "papercut-common"})
public final class SecureSerializationFilter {
    private static final KLogger logger;
    public static final SecureSerializationFilter INSTANCE;

    @JvmStatic
    public static final void installGlobalFilter(@NotNull String serializationConfigFile) {
        block0: {
            String pattern;
            Intrinsics.checkParameterIsNotNull((Object)serializationConfigFile, (String)"serializationConfigFile");
            String string = pattern = INSTANCE.filterPattern(serializationConfigFile);
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            ObjectInputFilter.Config.setSerialFilter(ObjectInputFilter.Config.createFilter(pattern));
        }
    }

    private final String filterPattern(String serializationConfigFile) {
        Properties properties = this.getFilterProperties(serializationConfigFile);
        String blackListPattern2 = CollectionsKt.joinToString$default((Iterable)this.getMultiValueProperty(properties, "blacklist"), (CharSequence)";", null, null, (int)0, null, (Function1)filterPattern.blackListPattern.1.INSTANCE, (int)30, null);
        String whiteListPattern2 = CollectionsKt.joinToString$default((Iterable)this.getMultiValueProperty(properties, "whitelist"), (CharSequence)";", null, null, (int)0, null, (Function1)filterPattern.whiteListPattern.1.INSTANCE, (int)30, null);
        CharSequence charSequence = blackListPattern2;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = whiteListPattern2;
            bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                logger.debug((Function0)new Function0<String>(blackListPattern2){
                    final /* synthetic */ String $blackListPattern;

                    @NotNull
                    public final String invoke() {
                        return "Configure global de-serialization with black-list pattern: " + this.$blackListPattern;
                    }
                    {
                        this.$blackListPattern = string;
                        super(0);
                    }
                });
                logger.debug((Function0)new Function0<String>(whiteListPattern2){
                    final /* synthetic */ String $whiteListPattern;

                    @NotNull
                    public final String invoke() {
                        return "Configure global de-serialization with white-list pattern: " + this.$whiteListPattern;
                    }
                    {
                        this.$whiteListPattern = string;
                        super(0);
                    }
                });
                return blackListPattern2 + ';' + whiteListPattern2;
            }
        }
        charSequence = blackListPattern2;
        bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            logger.debug((Function0)new Function0<String>(blackListPattern2){
                final /* synthetic */ String $blackListPattern;

                @NotNull
                public final String invoke() {
                    return "Configure global de-serialization with black-list pattern: " + this.$blackListPattern;
                }
                {
                    this.$blackListPattern = string;
                    super(0);
                }
            });
            return blackListPattern2;
        }
        charSequence = whiteListPattern2;
        bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            logger.debug((Function0)new Function0<String>(whiteListPattern2){
                final /* synthetic */ String $whiteListPattern;

                @NotNull
                public final String invoke() {
                    return "Configure global de-serialization with white-list pattern: " + this.$whiteListPattern;
                }
                {
                    this.$whiteListPattern = string;
                    super(0);
                }
            });
            return whiteListPattern2;
        }
        return null;
    }

    private final Properties getFilterProperties(String serializationConfigFile) {
        Properties properties;
        try {
            properties = this.loadProperties(serializationConfigFile);
        }
        catch (IOException e) {
            logger.debug((Function0)getFilterProperties.1.INSTANCE);
            properties = this.defaultPatterns();
        }
        return properties;
    }

    private final Properties defaultPatterns() {
        Properties properties = new Properties();
        boolean bl = false;
        boolean bl2 = false;
        Properties $this$apply = properties;
        boolean bl3 = false;
        $this$apply.setProperty("blacklist", "bsh.XThis, bsh.Interpreter,com.mchange.v2.c3p0.impl.*,org.apache.commons.beanutils.BeanComparator,org.apache.commons.collections.Transformer,org.apache.commons.collections.functors.*,org.apache.commons.collections4.functors.*,org.apache.commons.fileupload.disk.DiskFileItem,org.codehaus.groovy.runtime.*,java.rmi.server.*,javax.xml.transform.Templates,org.hibernate.tuple.**,org.hibernate.type.*,org.hibernate.engine.**,com.sun.org.apache.xalan.internal.xsltc.*,org.mozilla.javascript.*,java.lang.reflect.Proxy,javax.management.**,org.springframework.aop.framework.JdkDynamicAopProxy,org.jboss.weld.interceptor.**,java.beans.EventHandler,java.util.Comparator,net.sf.json.JSONObject,org.python.core.*,org.reflections.Reflections");
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getMultiValueProperty(@NotNull Properties $this$getMultiValueProperty, String propName) {
        void $this$mapTo$iv$iv;
        String string = $this$getMultiValueProperty.getProperty(propName, "");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getProperty(propName, \"\")");
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_12 = it;
            boolean bl2 = false;
            void v1 = var12_12;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
            collection.add(string3);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Properties loadProperties(String filePath) {
        Properties properties = new Properties();
        boolean bl = false;
        boolean bl2 = false;
        Properties $this$apply = properties;
        boolean bl3 = false;
        Closeable closeable = new FileInputStream(new File(filePath));
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl5 = false;
            logger.debug((Function0)new Function0<String>($this$apply, filePath){
                final /* synthetic */ Properties $this_apply$inlined;
                final /* synthetic */ String $filePath$inlined;
                {
                    this.$this_apply$inlined = properties;
                    this.$filePath$inlined = string;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Loading serialization pattern configuration from " + this.$filePath$inlined;
                }
            });
            $this$apply.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return properties;
    }

    private SecureSerializationFilter() {
    }

    static {
        SecureSerializationFilter secureSerializationFilter;
        INSTANCE = secureSerializationFilter = new SecureSerializationFilter();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }
}

